package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.PaginationToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListProjectsResponse(
    projects: Optional[Iterable[zio.aws.lookoutvision.model.ProjectMetadata]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse = {
    import ListProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse
      .builder()
      .optionallyWith(
        projects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projects)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ListProjectsResponse.ReadOnly =
    zio.aws.lookoutvision.model.ListProjectsResponse.wrap(buildAwsValue())
}
object ListProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ListProjectsResponse =
      zio.aws.lookoutvision.model.ListProjectsResponse(
        projects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def projects
        : Optional[List[zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getProjects: ZIO[Any, AwsError, List[
      zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("projects", projects)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse
  ) extends zio.aws.lookoutvision.model.ListProjectsResponse.ReadOnly {
    override val projects
        : Optional[List[zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutvision.model.ProjectMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListProjectsResponse
  ): zio.aws.lookoutvision.model.ListProjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
