package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.AnomalyName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Anomaly(
    name: Optional[AnomalyName] = Optional.Absent,
    pixelAnomaly: Optional[zio.aws.lookoutvision.model.PixelAnomaly] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.Anomaly = {
    import Anomaly.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.Anomaly
      .builder()
      .optionallyWith(
        name.map(value => AnomalyName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(pixelAnomaly.map(value => value.buildAwsValue()))(
        _.pixelAnomaly
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.Anomaly.ReadOnly =
    zio.aws.lookoutvision.model.Anomaly.wrap(buildAwsValue())
}
object Anomaly {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.Anomaly
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.Anomaly =
      zio.aws.lookoutvision.model.Anomaly(
        name.map(value => value),
        pixelAnomaly.map(value => value.asEditable)
      )
    def name: Optional[AnomalyName]
    def pixelAnomaly
        : Optional[zio.aws.lookoutvision.model.PixelAnomaly.ReadOnly]
    def getName: ZIO[Any, AwsError, AnomalyName] =
      AwsError.unwrapOptionField("name", name)
    def getPixelAnomaly: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.PixelAnomaly.ReadOnly
    ] = AwsError.unwrapOptionField("pixelAnomaly", pixelAnomaly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.Anomaly
  ) extends zio.aws.lookoutvision.model.Anomaly.ReadOnly {
    override val name: Optional[AnomalyName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lookoutvision.model.primitives.AnomalyName(value))
    override val pixelAnomaly
        : Optional[zio.aws.lookoutvision.model.PixelAnomaly.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pixelAnomaly())
        .map(value => zio.aws.lookoutvision.model.PixelAnomaly.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.Anomaly
  ): zio.aws.lookoutvision.model.Anomaly.ReadOnly = new Wrapper(impl)
}
