package zio.aws.lookoutvision.model
import scala.jdk.CollectionConverters._
sealed trait TargetPlatformArch {
  def unwrap
      : software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch
}
object TargetPlatformArch {
  def wrap(
      value: software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch
  ): zio.aws.lookoutvision.model.TargetPlatformArch = value match {
    case software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch.ARM64 =>
      val r = ARM64
      r
    case software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch.X86_64 =>
      val r = X86_64
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutvision.model.TargetPlatformArch {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch =
      software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch.UNKNOWN_TO_SDK_VERSION
  }
  case object ARM64 extends zio.aws.lookoutvision.model.TargetPlatformArch {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch =
      software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch.ARM64
  }
  case object X86_64 extends zio.aws.lookoutvision.model.TargetPlatformArch {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch =
      software.amazon.awssdk.services.lookoutvision.model.TargetPlatformArch.X86_64
  }
}
