package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lookoutvision.model.primitives.{
  ModelPackagingJobName,
  ProjectName
}
import scala.jdk.CollectionConverters._
final case class DescribeModelPackagingJobRequest(
    projectName: ProjectName,
    jobName: ModelPackagingJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobRequest = {
    import DescribeModelPackagingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .jobName(ModelPackagingJobName.unwrap(jobName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.DescribeModelPackagingJobRequest.ReadOnly =
    zio.aws.lookoutvision.model.DescribeModelPackagingJobRequest
      .wrap(buildAwsValue())
}
object DescribeModelPackagingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutvision.model.DescribeModelPackagingJobRequest =
      zio.aws.lookoutvision.model
        .DescribeModelPackagingJobRequest(projectName, jobName)
    def projectName: ProjectName
    def jobName: ModelPackagingJobName
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getJobName: ZIO[Any, Nothing, ModelPackagingJobName] =
      ZIO.succeed(jobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobRequest
  ) extends zio.aws.lookoutvision.model.DescribeModelPackagingJobRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val jobName: ModelPackagingJobName =
      zio.aws.lookoutvision.model.primitives
        .ModelPackagingJobName(impl.jobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeModelPackagingJobRequest
  ): zio.aws.lookoutvision.model.DescribeModelPackagingJobRequest.ReadOnly =
    new Wrapper(impl)
}
