package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateModelResponse(
    modelMetadata: Optional[zio.aws.lookoutvision.model.ModelMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.CreateModelResponse = {
    import CreateModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.CreateModelResponse
      .builder()
      .optionallyWith(modelMetadata.map(value => value.buildAwsValue()))(
        _.modelMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.CreateModelResponse.ReadOnly =
    zio.aws.lookoutvision.model.CreateModelResponse.wrap(buildAwsValue())
}
object CreateModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.CreateModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.CreateModelResponse =
      zio.aws.lookoutvision.model
        .CreateModelResponse(modelMetadata.map(value => value.asEditable))
    def modelMetadata
        : Optional[zio.aws.lookoutvision.model.ModelMetadata.ReadOnly]
    def getModelMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("modelMetadata", modelMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.CreateModelResponse
  ) extends zio.aws.lookoutvision.model.CreateModelResponse.ReadOnly {
    override val modelMetadata
        : Optional[zio.aws.lookoutvision.model.ModelMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelMetadata())
        .map(value => zio.aws.lookoutvision.model.ModelMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.CreateModelResponse
  ): zio.aws.lookoutvision.model.CreateModelResponse.ReadOnly = new Wrapper(
    impl
  )
}
