package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  KmsKeyId,
  ClientToken,
  ModelDescriptionMessage,
  ProjectName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateModelRequest(
    projectName: ProjectName,
    description: Optional[ModelDescriptionMessage] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    outputConfig: zio.aws.lookoutvision.model.OutputConfig,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.lookoutvision.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.CreateModelRequest = {
    import CreateModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.CreateModelRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ModelDescriptionMessage.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .outputConfig(outputConfig.buildAwsValue())
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.CreateModelRequest.ReadOnly =
    zio.aws.lookoutvision.model.CreateModelRequest.wrap(buildAwsValue())
}
object CreateModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.CreateModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.CreateModelRequest =
      zio.aws.lookoutvision.model.CreateModelRequest(
        projectName,
        description.map(value => value),
        clientToken.map(value => value),
        outputConfig.asEditable,
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def projectName: ProjectName
    def description: Optional[ModelDescriptionMessage]
    def clientToken: Optional[ClientToken]
    def outputConfig: zio.aws.lookoutvision.model.OutputConfig.ReadOnly
    def kmsKeyId: Optional[KmsKeyId]
    def tags: Optional[List[zio.aws.lookoutvision.model.Tag.ReadOnly]]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getDescription: ZIO[Any, AwsError, ModelDescriptionMessage] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getOutputConfig
        : ZIO[Any, Nothing, zio.aws.lookoutvision.model.OutputConfig.ReadOnly] =
      ZIO.succeed(outputConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lookoutvision.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.CreateModelRequest
  ) extends zio.aws.lookoutvision.model.CreateModelRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val description: Optional[ModelDescriptionMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.lookoutvision.model.primitives.ModelDescriptionMessage(value)
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.lookoutvision.model.primitives.ClientToken(value))
    override val outputConfig
        : zio.aws.lookoutvision.model.OutputConfig.ReadOnly =
      zio.aws.lookoutvision.model.OutputConfig.wrap(impl.outputConfig())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.lookoutvision.model.primitives.KmsKeyId(value))
    override val tags
        : Optional[List[zio.aws.lookoutvision.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutvision.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.CreateModelRequest
  ): zio.aws.lookoutvision.model.CreateModelRequest.ReadOnly = new Wrapper(impl)
}
