package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.Color
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PixelAnomaly(
    totalPercentageArea: Optional[Float] = Optional.Absent,
    color: Optional[Color] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.PixelAnomaly = {
    import PixelAnomaly.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.PixelAnomaly
      .builder()
      .optionallyWith(totalPercentageArea.map(value => value: java.lang.Float))(
        _.totalPercentageArea
      )
      .optionallyWith(
        color.map(value => Color.unwrap(value): java.lang.String)
      )(_.color)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.PixelAnomaly.ReadOnly =
    zio.aws.lookoutvision.model.PixelAnomaly.wrap(buildAwsValue())
}
object PixelAnomaly {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.PixelAnomaly
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.PixelAnomaly =
      zio.aws.lookoutvision.model.PixelAnomaly(
        totalPercentageArea.map(value => value),
        color.map(value => value)
      )
    def totalPercentageArea: Optional[Float]
    def color: Optional[Color]
    def getTotalPercentageArea: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("totalPercentageArea", totalPercentageArea)
    def getColor: ZIO[Any, AwsError, Color] =
      AwsError.unwrapOptionField("color", color)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.PixelAnomaly
  ) extends zio.aws.lookoutvision.model.PixelAnomaly.ReadOnly {
    override val totalPercentageArea: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.totalPercentageArea())
      .map(value => value: Float)
    override val color: Optional[Color] = zio.aws.core.internal
      .optionalFromNullable(impl.color())
      .map(value => zio.aws.lookoutvision.model.primitives.Color(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.PixelAnomaly
  ): zio.aws.lookoutvision.model.PixelAnomaly.ReadOnly = new Wrapper(impl)
}
