package zio.aws.lookoutvision.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.lookoutvision.model.primitives.{
  ModelPackagingJobName,
  ProjectName,
  ModelPackagingMethod,
  ModelVersion,
  DateTime,
  ModelPackagingStatusMessage,
  ModelPackagingJobDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ModelPackagingDescription(
    jobName: Optional[ModelPackagingJobName] = Optional.Absent,
    projectName: Optional[ProjectName] = Optional.Absent,
    modelVersion: Optional[ModelVersion] = Optional.Absent,
    modelPackagingConfiguration: Optional[
      zio.aws.lookoutvision.model.ModelPackagingConfiguration
    ] = Optional.Absent,
    modelPackagingJobDescription: Optional[ModelPackagingJobDescription] =
      Optional.Absent,
    modelPackagingMethod: Optional[ModelPackagingMethod] = Optional.Absent,
    modelPackagingOutputDetails: Optional[
      zio.aws.lookoutvision.model.ModelPackagingOutputDetails
    ] = Optional.Absent,
    status: Optional[zio.aws.lookoutvision.model.ModelPackagingJobStatus] =
      Optional.Absent,
    statusMessage: Optional[ModelPackagingStatusMessage] = Optional.Absent,
    creationTimestamp: Optional[DateTime] = Optional.Absent,
    lastUpdatedTimestamp: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ModelPackagingDescription = {
    import ModelPackagingDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ModelPackagingDescription
      .builder()
      .optionallyWith(
        jobName.map(value =>
          ModelPackagingJobName.unwrap(value): java.lang.String
        )
      )(_.jobName)
      .optionallyWith(
        projectName.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(
        modelVersion.map(value => ModelVersion.unwrap(value): java.lang.String)
      )(_.modelVersion)
      .optionallyWith(
        modelPackagingConfiguration.map(value => value.buildAwsValue())
      )(_.modelPackagingConfiguration)
      .optionallyWith(
        modelPackagingJobDescription.map(value =>
          ModelPackagingJobDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackagingJobDescription)
      .optionallyWith(
        modelPackagingMethod.map(value =>
          ModelPackagingMethod.unwrap(value): java.lang.String
        )
      )(_.modelPackagingMethod)
      .optionallyWith(
        modelPackagingOutputDetails.map(value => value.buildAwsValue())
      )(_.modelPackagingOutputDetails)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          ModelPackagingStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.ModelPackagingDescription.ReadOnly =
    zio.aws.lookoutvision.model.ModelPackagingDescription.wrap(buildAwsValue())
}
object ModelPackagingDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ModelPackagingDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ModelPackagingDescription =
      zio.aws.lookoutvision.model.ModelPackagingDescription(
        jobName.map(value => value),
        projectName.map(value => value),
        modelVersion.map(value => value),
        modelPackagingConfiguration.map(value => value.asEditable),
        modelPackagingJobDescription.map(value => value),
        modelPackagingMethod.map(value => value),
        modelPackagingOutputDetails.map(value => value.asEditable),
        status.map(value => value),
        statusMessage.map(value => value),
        creationTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def jobName: Optional[ModelPackagingJobName]
    def projectName: Optional[ProjectName]
    def modelVersion: Optional[ModelVersion]
    def modelPackagingConfiguration: Optional[
      zio.aws.lookoutvision.model.ModelPackagingConfiguration.ReadOnly
    ]
    def modelPackagingJobDescription: Optional[ModelPackagingJobDescription]
    def modelPackagingMethod: Optional[ModelPackagingMethod]
    def modelPackagingOutputDetails: Optional[
      zio.aws.lookoutvision.model.ModelPackagingOutputDetails.ReadOnly
    ]
    def status: Optional[zio.aws.lookoutvision.model.ModelPackagingJobStatus]
    def statusMessage: Optional[ModelPackagingStatusMessage]
    def creationTimestamp: Optional[DateTime]
    def lastUpdatedTimestamp: Optional[DateTime]
    def getJobName: ZIO[Any, AwsError, ModelPackagingJobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getProjectName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getModelPackagingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelPackagingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "modelPackagingConfiguration",
      modelPackagingConfiguration
    )
    def getModelPackagingJobDescription
        : ZIO[Any, AwsError, ModelPackagingJobDescription] =
      AwsError.unwrapOptionField(
        "modelPackagingJobDescription",
        modelPackagingJobDescription
      )
    def getModelPackagingMethod: ZIO[Any, AwsError, ModelPackagingMethod] =
      AwsError.unwrapOptionField("modelPackagingMethod", modelPackagingMethod)
    def getModelPackagingOutputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelPackagingOutputDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "modelPackagingOutputDetails",
      modelPackagingOutputDetails
    )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelPackagingJobStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, ModelPackagingStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelPackagingDescription
  ) extends zio.aws.lookoutvision.model.ModelPackagingDescription.ReadOnly {
    override val jobName: Optional[ModelPackagingJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobName())
        .map(value =>
          zio.aws.lookoutvision.model.primitives.ModelPackagingJobName(value)
        )
    override val projectName: Optional[ProjectName] = zio.aws.core.internal
      .optionalFromNullable(impl.projectName())
      .map(value => zio.aws.lookoutvision.model.primitives.ProjectName(value))
    override val modelVersion: Optional[ModelVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.modelVersion())
      .map(value => zio.aws.lookoutvision.model.primitives.ModelVersion(value))
    override val modelPackagingConfiguration: Optional[
      zio.aws.lookoutvision.model.ModelPackagingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.modelPackagingConfiguration())
      .map(value =>
        zio.aws.lookoutvision.model.ModelPackagingConfiguration.wrap(value)
      )
    override val modelPackagingJobDescription
        : Optional[ModelPackagingJobDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.modelPackagingJobDescription())
      .map(value =>
        zio.aws.lookoutvision.model.primitives
          .ModelPackagingJobDescription(value)
      )
    override val modelPackagingMethod: Optional[ModelPackagingMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackagingMethod())
        .map(value =>
          zio.aws.lookoutvision.model.primitives.ModelPackagingMethod(value)
        )
    override val modelPackagingOutputDetails: Optional[
      zio.aws.lookoutvision.model.ModelPackagingOutputDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.modelPackagingOutputDetails())
      .map(value =>
        zio.aws.lookoutvision.model.ModelPackagingOutputDetails.wrap(value)
      )
    override val status
        : Optional[zio.aws.lookoutvision.model.ModelPackagingJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutvision.model.ModelPackagingJobStatus.wrap(value)
        )
    override val statusMessage: Optional[ModelPackagingStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.lookoutvision.model.primitives
            .ModelPackagingStatusMessage(value)
        )
    override val creationTimestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val lastUpdatedTimestamp: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelPackagingDescription
  ): zio.aws.lookoutvision.model.ModelPackagingDescription.ReadOnly =
    new Wrapper(impl)
}
