package zio.aws.lookoutvision.model
import scala.jdk.CollectionConverters._
sealed trait TargetPlatformOs {
  def unwrap
      : software.amazon.awssdk.services.lookoutvision.model.TargetPlatformOs
}
object TargetPlatformOs {
  def wrap(
      value: software.amazon.awssdk.services.lookoutvision.model.TargetPlatformOs
  ): zio.aws.lookoutvision.model.TargetPlatformOs = value match {
    case software.amazon.awssdk.services.lookoutvision.model.TargetPlatformOs.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutvision.model.TargetPlatformOs.LINUX =>
      val r = LINUX
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutvision.model.TargetPlatformOs {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.TargetPlatformOs =
      software.amazon.awssdk.services.lookoutvision.model.TargetPlatformOs.UNKNOWN_TO_SDK_VERSION
  }
  case object LINUX extends zio.aws.lookoutvision.model.TargetPlatformOs {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.TargetPlatformOs =
      software.amazon.awssdk.services.lookoutvision.model.TargetPlatformOs.LINUX
  }
}
