package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModelPackagingOutputDetails(
    greengrass: Optional[zio.aws.lookoutvision.model.GreengrassOutputDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ModelPackagingOutputDetails = {
    import ModelPackagingOutputDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ModelPackagingOutputDetails
      .builder()
      .optionallyWith(greengrass.map(value => value.buildAwsValue()))(
        _.greengrass
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.ModelPackagingOutputDetails.ReadOnly =
    zio.aws.lookoutvision.model.ModelPackagingOutputDetails
      .wrap(buildAwsValue())
}
object ModelPackagingOutputDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ModelPackagingOutputDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ModelPackagingOutputDetails =
      zio.aws.lookoutvision.model
        .ModelPackagingOutputDetails(greengrass.map(value => value.asEditable))
    def greengrass
        : Optional[zio.aws.lookoutvision.model.GreengrassOutputDetails.ReadOnly]
    def getGreengrass: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.GreengrassOutputDetails.ReadOnly
    ] = AwsError.unwrapOptionField("greengrass", greengrass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelPackagingOutputDetails
  ) extends zio.aws.lookoutvision.model.ModelPackagingOutputDetails.ReadOnly {
    override val greengrass: Optional[
      zio.aws.lookoutvision.model.GreengrassOutputDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.greengrass())
      .map(value =>
        zio.aws.lookoutvision.model.GreengrassOutputDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelPackagingOutputDetails
  ): zio.aws.lookoutvision.model.ModelPackagingOutputDetails.ReadOnly =
    new Wrapper(impl)
}
