package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDatasetResponse(
    datasetMetadata: Optional[zio.aws.lookoutvision.model.DatasetMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.CreateDatasetResponse = {
    import CreateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.CreateDatasetResponse
      .builder()
      .optionallyWith(datasetMetadata.map(value => value.buildAwsValue()))(
        _.datasetMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.CreateDatasetResponse.ReadOnly =
    zio.aws.lookoutvision.model.CreateDatasetResponse.wrap(buildAwsValue())
}
object CreateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.CreateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.CreateDatasetResponse =
      zio.aws.lookoutvision.model
        .CreateDatasetResponse(datasetMetadata.map(value => value.asEditable))
    def datasetMetadata
        : Optional[zio.aws.lookoutvision.model.DatasetMetadata.ReadOnly]
    def getDatasetMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.DatasetMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("datasetMetadata", datasetMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.CreateDatasetResponse
  ) extends zio.aws.lookoutvision.model.CreateDatasetResponse.ReadOnly {
    override val datasetMetadata
        : Optional[zio.aws.lookoutvision.model.DatasetMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetMetadata())
        .map(value => zio.aws.lookoutvision.model.DatasetMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.CreateDatasetResponse
  ): zio.aws.lookoutvision.model.CreateDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
