package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lookoutvision.model.primitives.TagArn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: TagArn,
    tags: Iterable[zio.aws.lookoutvision.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.TagResourceRequest
      .builder()
      .resourceArn(TagArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.TagResourceRequest.ReadOnly =
    zio.aws.lookoutvision.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.TagResourceRequest =
      zio.aws.lookoutvision.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: TagArn
    def tags: List[zio.aws.lookoutvision.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, TagArn] = ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.lookoutvision.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.TagResourceRequest
  ) extends zio.aws.lookoutvision.model.TagResourceRequest.ReadOnly {
    override val resourceArn: TagArn =
      zio.aws.lookoutvision.model.primitives.TagArn(impl.resourceArn())
    override val tags: List[zio.aws.lookoutvision.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.lookoutvision.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.TagResourceRequest
  ): zio.aws.lookoutvision.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
