package zio.aws.lookoutvision.model
import scala.jdk.CollectionConverters._
sealed trait ModelStatus {
  def unwrap: software.amazon.awssdk.services.lookoutvision.model.ModelStatus
}
object ModelStatus {
  def wrap(
      value: software.amazon.awssdk.services.lookoutvision.model.ModelStatus
  ): zio.aws.lookoutvision.model.ModelStatus = value match {
    case software.amazon.awssdk.services.lookoutvision.model.ModelStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelStatus.TRAINING =>
      val r = TRAINING
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelStatus.TRAINED =>
      val r = TRAINED
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelStatus.TRAINING_FAILED =>
      val r = TRAINING_FAILED
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelStatus.STARTING_HOSTING =>
      val r = STARTING_HOSTING
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelStatus.HOSTED =>
      val r = HOSTED
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelStatus.HOSTING_FAILED =>
      val r = HOSTING_FAILED
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelStatus.STOPPING_HOSTING =>
      val r = STOPPING_HOSTING
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelStatus.SYSTEM_UPDATING =>
      val r = SYSTEM_UPDATING
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutvision.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object TRAINING extends zio.aws.lookoutvision.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelStatus.TRAINING
  }
  case object TRAINED extends zio.aws.lookoutvision.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelStatus.TRAINED
  }
  case object TRAINING_FAILED extends zio.aws.lookoutvision.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelStatus.TRAINING_FAILED
  }
  case object STARTING_HOSTING extends zio.aws.lookoutvision.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelStatus.STARTING_HOSTING
  }
  case object HOSTED extends zio.aws.lookoutvision.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelStatus.HOSTED
  }
  case object HOSTING_FAILED extends zio.aws.lookoutvision.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelStatus.HOSTING_FAILED
  }
  case object STOPPING_HOSTING extends zio.aws.lookoutvision.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelStatus.STOPPING_HOSTING
  }
  case object SYSTEM_UPDATING extends zio.aws.lookoutvision.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelStatus.SYSTEM_UPDATING
  }
  case object DELETING extends zio.aws.lookoutvision.model.ModelStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelStatus.DELETING
  }
}
