package zio.aws.lookoutvision.model
import scala.jdk.CollectionConverters._
sealed trait ModelPackagingJobStatus {
  def unwrap: software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus
}
object ModelPackagingJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus
  ): zio.aws.lookoutvision.model.ModelPackagingJobStatus = value match {
    case software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutvision.model.ModelPackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED
      extends zio.aws.lookoutvision.model.ModelPackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus.CREATED
  }
  case object RUNNING
      extends zio.aws.lookoutvision.model.ModelPackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus.RUNNING
  }
  case object SUCCEEDED
      extends zio.aws.lookoutvision.model.ModelPackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus.SUCCEEDED
  }
  case object FAILED
      extends zio.aws.lookoutvision.model.ModelPackagingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobStatus.FAILED
  }
}
