package zio.aws.lookoutvision.model
import scala.jdk.CollectionConverters._
sealed trait ModelHostingStatus {
  def unwrap
      : software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus
}
object ModelHostingStatus {
  def wrap(
      value: software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus
  ): zio.aws.lookoutvision.model.ModelHostingStatus = value match {
    case software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.STARTING_HOSTING =>
      val r = STARTING_HOSTING
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.HOSTED =>
      val r = HOSTED
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.HOSTING_FAILED =>
      val r = HOSTING_FAILED
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.STOPPING_HOSTING =>
      val r = STOPPING_HOSTING
      r
    case software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.SYSTEM_UPDATING =>
      val r = SYSTEM_UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutvision.model.ModelHostingStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTING_HOSTING
      extends zio.aws.lookoutvision.model.ModelHostingStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.STARTING_HOSTING
  }
  case object HOSTED extends zio.aws.lookoutvision.model.ModelHostingStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.HOSTED
  }
  case object HOSTING_FAILED
      extends zio.aws.lookoutvision.model.ModelHostingStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.HOSTING_FAILED
  }
  case object STOPPING_HOSTING
      extends zio.aws.lookoutvision.model.ModelHostingStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.STOPPING_HOSTING
  }
  case object SYSTEM_UPDATING
      extends zio.aws.lookoutvision.model.ModelHostingStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus =
      software.amazon.awssdk.services.lookoutvision.model.ModelHostingStatus.SYSTEM_UPDATING
  }
}
