package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatasetSource(
    groundTruthManifest: Optional[
      zio.aws.lookoutvision.model.DatasetGroundTruthManifest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DatasetSource = {
    import DatasetSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DatasetSource
      .builder()
      .optionallyWith(groundTruthManifest.map(value => value.buildAwsValue()))(
        _.groundTruthManifest
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DatasetSource.ReadOnly =
    zio.aws.lookoutvision.model.DatasetSource.wrap(buildAwsValue())
}
object DatasetSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DatasetSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DatasetSource =
      zio.aws.lookoutvision.model
        .DatasetSource(groundTruthManifest.map(value => value.asEditable))
    def groundTruthManifest: Optional[
      zio.aws.lookoutvision.model.DatasetGroundTruthManifest.ReadOnly
    ]
    def getGroundTruthManifest: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.DatasetGroundTruthManifest.ReadOnly
    ] = AwsError.unwrapOptionField("groundTruthManifest", groundTruthManifest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DatasetSource
  ) extends zio.aws.lookoutvision.model.DatasetSource.ReadOnly {
    override val groundTruthManifest: Optional[
      zio.aws.lookoutvision.model.DatasetGroundTruthManifest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groundTruthManifest())
      .map(value =>
        zio.aws.lookoutvision.model.DatasetGroundTruthManifest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DatasetSource
  ): zio.aws.lookoutvision.model.DatasetSource.ReadOnly = new Wrapper(impl)
}
