package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  ClientToken,
  DatasetChanges,
  DatasetType,
  ProjectName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDatasetEntriesRequest(
    projectName: ProjectName,
    datasetType: DatasetType,
    changes: DatasetChanges,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesRequest = {
    import UpdateDatasetEntriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .datasetType(DatasetType.unwrap(datasetType): java.lang.String)
      .changes(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(changes.toArray[Byte])
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.UpdateDatasetEntriesRequest.ReadOnly =
    zio.aws.lookoutvision.model.UpdateDatasetEntriesRequest
      .wrap(buildAwsValue())
}
object UpdateDatasetEntriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.UpdateDatasetEntriesRequest =
      zio.aws.lookoutvision.model.UpdateDatasetEntriesRequest(
        projectName,
        datasetType,
        changes,
        clientToken.map(value => value)
      )
    def projectName: ProjectName
    def datasetType: DatasetType
    def changes: DatasetChanges
    def clientToken: Optional[ClientToken]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getDatasetType: ZIO[Any, Nothing, DatasetType] =
      ZIO.succeed(datasetType)
    def getChanges: ZIO[Any, Nothing, DatasetChanges] = ZIO.succeed(changes)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesRequest
  ) extends zio.aws.lookoutvision.model.UpdateDatasetEntriesRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val datasetType: DatasetType =
      zio.aws.lookoutvision.model.primitives.DatasetType(impl.datasetType())
    override val changes: DatasetChanges =
      zio.aws.lookoutvision.model.primitives
        .DatasetChanges(zio.Chunk.fromArray(impl.changes().asByteArrayUnsafe()))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.lookoutvision.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesRequest
  ): zio.aws.lookoutvision.model.UpdateDatasetEntriesRequest.ReadOnly =
    new Wrapper(impl)
}
