package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.PaginationToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListModelsResponse(
    models: Optional[Iterable[zio.aws.lookoutvision.model.ModelMetadata]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse = {
    import ListModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse
      .builder()
      .optionallyWith(
        models.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.models)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ListModelsResponse.ReadOnly =
    zio.aws.lookoutvision.model.ListModelsResponse.wrap(buildAwsValue())
}
object ListModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ListModelsResponse =
      zio.aws.lookoutvision.model.ListModelsResponse(
        models.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def models
        : Optional[List[zio.aws.lookoutvision.model.ModelMetadata.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getModels: ZIO[Any, AwsError, List[
      zio.aws.lookoutvision.model.ModelMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("models", models)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse
  ) extends zio.aws.lookoutvision.model.ListModelsResponse.ReadOnly {
    override val models
        : Optional[List[zio.aws.lookoutvision.model.ModelMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.models())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutvision.model.ModelMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse
  ): zio.aws.lookoutvision.model.ListModelsResponse.ReadOnly = new Wrapper(impl)
}
