package zio.aws.lookoutvision.model
import zio.prelude.data.Optional
import zio.aws.lookoutvision.model.primitives.{PageSize, PaginationToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProjectsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest = {
    import ListProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ListProjectsRequest.ReadOnly =
    zio.aws.lookoutvision.model.ListProjectsRequest.wrap(buildAwsValue())
}
object ListProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ListProjectsRequest =
      zio.aws.lookoutvision.model.ListProjectsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[PageSize]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest
  ) extends zio.aws.lookoutvision.model.ListProjectsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.PaginationToken(value)
      )
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.lookoutvision.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListProjectsRequest
  ): zio.aws.lookoutvision.model.ListProjectsRequest.ReadOnly = new Wrapper(
    impl
  )
}
