package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatasetGroundTruthManifest(
    s3Object: Optional[zio.aws.lookoutvision.model.InputS3Object] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DatasetGroundTruthManifest = {
    import DatasetGroundTruthManifest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DatasetGroundTruthManifest
      .builder()
      .optionallyWith(s3Object.map(value => value.buildAwsValue()))(_.s3Object)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.DatasetGroundTruthManifest.ReadOnly =
    zio.aws.lookoutvision.model.DatasetGroundTruthManifest.wrap(buildAwsValue())
}
object DatasetGroundTruthManifest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DatasetGroundTruthManifest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DatasetGroundTruthManifest =
      zio.aws.lookoutvision.model
        .DatasetGroundTruthManifest(s3Object.map(value => value.asEditable))
    def s3Object: Optional[zio.aws.lookoutvision.model.InputS3Object.ReadOnly]
    def getS3Object: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.InputS3Object.ReadOnly
    ] = AwsError.unwrapOptionField("s3Object", s3Object)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DatasetGroundTruthManifest
  ) extends zio.aws.lookoutvision.model.DatasetGroundTruthManifest.ReadOnly {
    override val s3Object
        : Optional[zio.aws.lookoutvision.model.InputS3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Object())
        .map(value => zio.aws.lookoutvision.model.InputS3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DatasetGroundTruthManifest
  ): zio.aws.lookoutvision.model.DatasetGroundTruthManifest.ReadOnly =
    new Wrapper(impl)
}
