package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OutputConfig(
    s3Location: zio.aws.lookoutvision.model.S3Location
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.OutputConfig = {
    import OutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.OutputConfig
      .builder()
      .s3Location(s3Location.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.OutputConfig.ReadOnly =
    zio.aws.lookoutvision.model.OutputConfig.wrap(buildAwsValue())
}
object OutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.OutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.OutputConfig =
      zio.aws.lookoutvision.model.OutputConfig(s3Location.asEditable)
    def s3Location: zio.aws.lookoutvision.model.S3Location.ReadOnly
    def getS3Location
        : ZIO[Any, Nothing, zio.aws.lookoutvision.model.S3Location.ReadOnly] =
      ZIO.succeed(s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.OutputConfig
  ) extends zio.aws.lookoutvision.model.OutputConfig.ReadOnly {
    override val s3Location: zio.aws.lookoutvision.model.S3Location.ReadOnly =
      zio.aws.lookoutvision.model.S3Location.wrap(impl.s3Location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.OutputConfig
  ): zio.aws.lookoutvision.model.OutputConfig.ReadOnly = new Wrapper(impl)
}
