package zio.aws.lookoutvision.model
import scala.jdk.CollectionConverters._
sealed trait DatasetStatus {
  def unwrap: software.amazon.awssdk.services.lookoutvision.model.DatasetStatus
}
object DatasetStatus {
  def wrap(
      value: software.amazon.awssdk.services.lookoutvision.model.DatasetStatus
  ): zio.aws.lookoutvision.model.DatasetStatus = value match {
    case software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.CREATE_COMPLETE =>
      val r = CREATE_COMPLETE
      r
    case software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.UPDATE_COMPLETE =>
      val r = UPDATE_COMPLETE
      r
    case software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.UPDATE_FAILED_ROLLBACK_IN_PROGRESS =>
      val r = UPDATE_FAILED_ROLLBACK_IN_PROGRESS
      r
    case software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.UPDATE_FAILED_ROLLBACK_COMPLETE =>
      val r = UPDATE_FAILED_ROLLBACK_COMPLETE
      r
    case software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.DELETE_COMPLETE =>
      val r = DELETE_COMPLETE
      r
    case software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutvision.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.lookoutvision.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_COMPLETE
      extends zio.aws.lookoutvision.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.CREATE_COMPLETE
  }
  case object CREATE_FAILED extends zio.aws.lookoutvision.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.CREATE_FAILED
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.lookoutvision.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.UPDATE_IN_PROGRESS
  }
  case object UPDATE_COMPLETE
      extends zio.aws.lookoutvision.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.UPDATE_COMPLETE
  }
  case object UPDATE_FAILED_ROLLBACK_IN_PROGRESS
      extends zio.aws.lookoutvision.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.UPDATE_FAILED_ROLLBACK_IN_PROGRESS
  }
  case object UPDATE_FAILED_ROLLBACK_COMPLETE
      extends zio.aws.lookoutvision.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.UPDATE_FAILED_ROLLBACK_COMPLETE
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.lookoutvision.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.DELETE_IN_PROGRESS
  }
  case object DELETE_COMPLETE
      extends zio.aws.lookoutvision.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.DELETE_COMPLETE
  }
  case object DELETE_FAILED extends zio.aws.lookoutvision.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutvision.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutvision.model.DatasetStatus.DELETE_FAILED
  }
}
