package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeProjectResponse(
    projectDescription: Optional[
      zio.aws.lookoutvision.model.ProjectDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DescribeProjectResponse = {
    import DescribeProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DescribeProjectResponse
      .builder()
      .optionallyWith(projectDescription.map(value => value.buildAwsValue()))(
        _.projectDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DescribeProjectResponse.ReadOnly =
    zio.aws.lookoutvision.model.DescribeProjectResponse.wrap(buildAwsValue())
}
object DescribeProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DescribeProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DescribeProjectResponse =
      zio.aws.lookoutvision.model.DescribeProjectResponse(
        projectDescription.map(value => value.asEditable)
      )
    def projectDescription
        : Optional[zio.aws.lookoutvision.model.ProjectDescription.ReadOnly]
    def getProjectDescription: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ProjectDescription.ReadOnly
    ] = AwsError.unwrapOptionField("projectDescription", projectDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeProjectResponse
  ) extends zio.aws.lookoutvision.model.DescribeProjectResponse.ReadOnly {
    override val projectDescription
        : Optional[zio.aws.lookoutvision.model.ProjectDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectDescription())
        .map(value =>
          zio.aws.lookoutvision.model.ProjectDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeProjectResponse
  ): zio.aws.lookoutvision.model.DescribeProjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
