package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lookoutvision.model.primitives.{ModelVersion, ProjectName}
import scala.jdk.CollectionConverters._
final case class DescribeModelRequest(
    projectName: ProjectName,
    modelVersion: ModelVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DescribeModelRequest = {
    import DescribeModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DescribeModelRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .modelVersion(ModelVersion.unwrap(modelVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DescribeModelRequest.ReadOnly =
    zio.aws.lookoutvision.model.DescribeModelRequest.wrap(buildAwsValue())
}
object DescribeModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DescribeModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DescribeModelRequest =
      zio.aws.lookoutvision.model
        .DescribeModelRequest(projectName, modelVersion)
    def projectName: ProjectName
    def modelVersion: ModelVersion
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getModelVersion: ZIO[Any, Nothing, ModelVersion] =
      ZIO.succeed(modelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeModelRequest
  ) extends zio.aws.lookoutvision.model.DescribeModelRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val modelVersion: ModelVersion =
      zio.aws.lookoutvision.model.primitives.ModelVersion(impl.modelVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeModelRequest
  ): zio.aws.lookoutvision.model.DescribeModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
