package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lookoutvision.model.primitives.TagArn
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: TagArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(TagArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.lookoutvision.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ListTagsForResourceRequest =
      zio.aws.lookoutvision.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: TagArn
    def getResourceArn: ZIO[Any, Nothing, TagArn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceRequest
  ) extends zio.aws.lookoutvision.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: TagArn =
      zio.aws.lookoutvision.model.primitives.TagArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListTagsForResourceRequest
  ): zio.aws.lookoutvision.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
