package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lookoutvision.model.primitives.ProjectName
import scala.jdk.CollectionConverters._
final case class DescribeProjectRequest(projectName: ProjectName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DescribeProjectRequest = {
    import DescribeProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DescribeProjectRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DescribeProjectRequest.ReadOnly =
    zio.aws.lookoutvision.model.DescribeProjectRequest.wrap(buildAwsValue())
}
object DescribeProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DescribeProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DescribeProjectRequest =
      zio.aws.lookoutvision.model.DescribeProjectRequest(projectName)
    def projectName: ProjectName
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeProjectRequest
  ) extends zio.aws.lookoutvision.model.DescribeProjectRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeProjectRequest
  ): zio.aws.lookoutvision.model.DescribeProjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
