package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  ClientToken,
  DatasetType,
  ProjectName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDatasetRequest(
    projectName: ProjectName,
    datasetType: DatasetType,
    datasetSource: Optional[zio.aws.lookoutvision.model.DatasetSource] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.CreateDatasetRequest = {
    import CreateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.CreateDatasetRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .datasetType(DatasetType.unwrap(datasetType): java.lang.String)
      .optionallyWith(datasetSource.map(value => value.buildAwsValue()))(
        _.datasetSource
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.CreateDatasetRequest.ReadOnly =
    zio.aws.lookoutvision.model.CreateDatasetRequest.wrap(buildAwsValue())
}
object CreateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.CreateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.CreateDatasetRequest =
      zio.aws.lookoutvision.model.CreateDatasetRequest(
        projectName,
        datasetType,
        datasetSource.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def projectName: ProjectName
    def datasetType: DatasetType
    def datasetSource
        : Optional[zio.aws.lookoutvision.model.DatasetSource.ReadOnly]
    def clientToken: Optional[ClientToken]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getDatasetType: ZIO[Any, Nothing, DatasetType] =
      ZIO.succeed(datasetType)
    def getDatasetSource: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.DatasetSource.ReadOnly
    ] = AwsError.unwrapOptionField("datasetSource", datasetSource)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.CreateDatasetRequest
  ) extends zio.aws.lookoutvision.model.CreateDatasetRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val datasetType: DatasetType =
      zio.aws.lookoutvision.model.primitives.DatasetType(impl.datasetType())
    override val datasetSource
        : Optional[zio.aws.lookoutvision.model.DatasetSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetSource())
        .map(value => zio.aws.lookoutvision.model.DatasetSource.wrap(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.lookoutvision.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.CreateDatasetRequest
  ): zio.aws.lookoutvision.model.CreateDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
