package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lookoutvision.model.primitives.{TagKey, TagArn}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: TagArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.UntagResourceRequest
      .builder()
      .resourceArn(TagArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.UntagResourceRequest.ReadOnly =
    zio.aws.lookoutvision.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.UntagResourceRequest =
      zio.aws.lookoutvision.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: TagArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, TagArn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.UntagResourceRequest
  ) extends zio.aws.lookoutvision.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: TagArn =
      zio.aws.lookoutvision.model.primitives.TagArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.lookoutvision.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.UntagResourceRequest
  ): zio.aws.lookoutvision.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
