package zio.aws.lookoutvision.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.lookoutvision.model.primitives.{
  ModelArn,
  ModelVersion,
  DateTime,
  KmsKeyId,
  ModelStatusMessage,
  ModelDescriptionMessage
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ModelDescription(
    modelVersion: Optional[ModelVersion] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    creationTimestamp: Optional[DateTime] = Optional.Absent,
    description: Optional[ModelDescriptionMessage] = Optional.Absent,
    status: Optional[zio.aws.lookoutvision.model.ModelStatus] = Optional.Absent,
    statusMessage: Optional[ModelStatusMessage] = Optional.Absent,
    performance: Optional[zio.aws.lookoutvision.model.ModelPerformance] =
      Optional.Absent,
    outputConfig: Optional[zio.aws.lookoutvision.model.OutputConfig] =
      Optional.Absent,
    evaluationManifest: Optional[zio.aws.lookoutvision.model.OutputS3Object] =
      Optional.Absent,
    evaluationResult: Optional[zio.aws.lookoutvision.model.OutputS3Object] =
      Optional.Absent,
    evaluationEndTimestamp: Optional[DateTime] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ModelDescription = {
    import ModelDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ModelDescription
      .builder()
      .optionallyWith(
        modelVersion.map(value => ModelVersion.unwrap(value): java.lang.String)
      )(_.modelVersion)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        description.map(value =>
          ModelDescriptionMessage.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          ModelStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(performance.map(value => value.buildAwsValue()))(
        _.performance
      )
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(evaluationManifest.map(value => value.buildAwsValue()))(
        _.evaluationManifest
      )
      .optionallyWith(evaluationResult.map(value => value.buildAwsValue()))(
        _.evaluationResult
      )
      .optionallyWith(
        evaluationEndTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.evaluationEndTimestamp)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ModelDescription.ReadOnly =
    zio.aws.lookoutvision.model.ModelDescription.wrap(buildAwsValue())
}
object ModelDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ModelDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ModelDescription =
      zio.aws.lookoutvision.model.ModelDescription(
        modelVersion.map(value => value),
        modelArn.map(value => value),
        creationTimestamp.map(value => value),
        description.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        performance.map(value => value.asEditable),
        outputConfig.map(value => value.asEditable),
        evaluationManifest.map(value => value.asEditable),
        evaluationResult.map(value => value.asEditable),
        evaluationEndTimestamp.map(value => value),
        kmsKeyId.map(value => value)
      )
    def modelVersion: Optional[ModelVersion]
    def modelArn: Optional[ModelArn]
    def creationTimestamp: Optional[DateTime]
    def description: Optional[ModelDescriptionMessage]
    def status: Optional[zio.aws.lookoutvision.model.ModelStatus]
    def statusMessage: Optional[ModelStatusMessage]
    def performance
        : Optional[zio.aws.lookoutvision.model.ModelPerformance.ReadOnly]
    def outputConfig
        : Optional[zio.aws.lookoutvision.model.OutputConfig.ReadOnly]
    def evaluationManifest
        : Optional[zio.aws.lookoutvision.model.OutputS3Object.ReadOnly]
    def evaluationResult
        : Optional[zio.aws.lookoutvision.model.OutputS3Object.ReadOnly]
    def evaluationEndTimestamp: Optional[DateTime]
    def kmsKeyId: Optional[KmsKeyId]
    def getModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getDescription: ZIO[Any, AwsError, ModelDescriptionMessage] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.lookoutvision.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, ModelStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getPerformance: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelPerformance.ReadOnly
    ] = AwsError.unwrapOptionField("performance", performance)
    def getOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.OutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getEvaluationManifest: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.OutputS3Object.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationManifest", evaluationManifest)
    def getEvaluationResult: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.OutputS3Object.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationResult", evaluationResult)
    def getEvaluationEndTimestamp: ZIO[Any, AwsError, DateTime] = AwsError
      .unwrapOptionField("evaluationEndTimestamp", evaluationEndTimestamp)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelDescription
  ) extends zio.aws.lookoutvision.model.ModelDescription.ReadOnly {
    override val modelVersion: Optional[ModelVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.modelVersion())
      .map(value => zio.aws.lookoutvision.model.primitives.ModelVersion(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutvision.model.primitives.ModelArn(value))
    override val creationTimestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val description: Optional[ModelDescriptionMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.lookoutvision.model.primitives.ModelDescriptionMessage(value)
        )
    override val status: Optional[zio.aws.lookoutvision.model.ModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lookoutvision.model.ModelStatus.wrap(value))
    override val statusMessage: Optional[ModelStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.lookoutvision.model.primitives.ModelStatusMessage(value)
        )
    override val performance
        : Optional[zio.aws.lookoutvision.model.ModelPerformance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performance())
        .map(value => zio.aws.lookoutvision.model.ModelPerformance.wrap(value))
    override val outputConfig
        : Optional[zio.aws.lookoutvision.model.OutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputConfig())
        .map(value => zio.aws.lookoutvision.model.OutputConfig.wrap(value))
    override val evaluationManifest
        : Optional[zio.aws.lookoutvision.model.OutputS3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationManifest())
        .map(value => zio.aws.lookoutvision.model.OutputS3Object.wrap(value))
    override val evaluationResult
        : Optional[zio.aws.lookoutvision.model.OutputS3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationResult())
        .map(value => zio.aws.lookoutvision.model.OutputS3Object.wrap(value))
    override val evaluationEndTimestamp: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationEndTimestamp())
        .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.lookoutvision.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelDescription
  ): zio.aws.lookoutvision.model.ModelDescription.ReadOnly = new Wrapper(impl)
}
