package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  ModelPackagingJobName,
  ProjectName,
  ModelVersion,
  ModelPackagingJobDescription,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class StartModelPackagingJobRequest(
    projectName: ProjectName,
    modelVersion: ModelVersion,
    jobName: Option[ModelPackagingJobName] = None,
    configuration: zio.aws.lookoutvision.model.ModelPackagingConfiguration,
    description: Option[ModelPackagingJobDescription] = None,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobRequest = {
    import StartModelPackagingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .modelVersion(ModelVersion.unwrap(modelVersion): java.lang.String)
      .optionallyWith(
        jobName.map(value =>
          ModelPackagingJobName.unwrap(value): java.lang.String
        )
      )(_.jobName)
      .configuration(configuration.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          ModelPackagingJobDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.StartModelPackagingJobRequest.ReadOnly =
    zio.aws.lookoutvision.model.StartModelPackagingJobRequest
      .wrap(buildAwsValue())
}
object StartModelPackagingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.StartModelPackagingJobRequest =
      zio.aws.lookoutvision.model.StartModelPackagingJobRequest(
        projectName,
        modelVersion,
        jobName.map(value => value),
        configuration.asEditable,
        description.map(value => value),
        clientToken.map(value => value)
      )
    def projectName: ProjectName
    def modelVersion: ModelVersion
    def jobName: Option[ModelPackagingJobName]
    def configuration
        : zio.aws.lookoutvision.model.ModelPackagingConfiguration.ReadOnly
    def description: Option[ModelPackagingJobDescription]
    def clientToken: Option[ClientToken]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getModelVersion: ZIO[Any, Nothing, ModelVersion] =
      ZIO.succeed(modelVersion)
    def getJobName: ZIO[Any, AwsError, ModelPackagingJobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutvision.model.ModelPackagingConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
    def getDescription: ZIO[Any, AwsError, ModelPackagingJobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobRequest
  ) extends zio.aws.lookoutvision.model.StartModelPackagingJobRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val modelVersion: ModelVersion =
      zio.aws.lookoutvision.model.primitives.ModelVersion(impl.modelVersion())
    override val jobName: Option[ModelPackagingJobName] = scala
      .Option(impl.jobName())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ModelPackagingJobName(value)
      )
    override val configuration
        : zio.aws.lookoutvision.model.ModelPackagingConfiguration.ReadOnly =
      zio.aws.lookoutvision.model.ModelPackagingConfiguration
        .wrap(impl.configuration())
    override val description: Option[ModelPackagingJobDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.lookoutvision.model.primitives
          .ModelPackagingJobDescription(value)
      )
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.lookoutvision.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobRequest
  ): zio.aws.lookoutvision.model.StartModelPackagingJobRequest.ReadOnly =
    new Wrapper(impl)
}
