package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModelPerformance(
    f1Score: Option[Float] = None,
    recall: Option[Float] = None,
    precision: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ModelPerformance = {
    import ModelPerformance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ModelPerformance
      .builder()
      .optionallyWith(f1Score.map(value => value: java.lang.Float))(_.f1Score)
      .optionallyWith(recall.map(value => value: java.lang.Float))(_.recall)
      .optionallyWith(precision.map(value => value: java.lang.Float))(
        _.precision
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ModelPerformance.ReadOnly =
    zio.aws.lookoutvision.model.ModelPerformance.wrap(buildAwsValue())
}
object ModelPerformance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ModelPerformance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ModelPerformance =
      zio.aws.lookoutvision.model.ModelPerformance(
        f1Score.map(value => value),
        recall.map(value => value),
        precision.map(value => value)
      )
    def f1Score: Option[Float]
    def recall: Option[Float]
    def precision: Option[Float]
    def getF1Score: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("f1Score", f1Score)
    def getRecall: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("recall", recall)
    def getPrecision: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("precision", precision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelPerformance
  ) extends zio.aws.lookoutvision.model.ModelPerformance.ReadOnly {
    override val f1Score: Option[Float] =
      scala.Option(impl.f1Score()).map(value => value: Float)
    override val recall: Option[Float] =
      scala.Option(impl.recall()).map(value => value: Float)
    override val precision: Option[Float] =
      scala.Option(impl.precision()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelPerformance
  ): zio.aws.lookoutvision.model.ModelPerformance.ReadOnly = new Wrapper(impl)
}
