package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  ModelPackagingJobName,
  ProjectName,
  ModelPackagingMethod,
  ModelVersion,
  DateTime,
  ModelPackagingStatusMessage,
  ModelPackagingJobDescription
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ModelPackagingJobMetadata(
    jobName: Option[ModelPackagingJobName] = None,
    projectName: Option[ProjectName] = None,
    modelVersion: Option[ModelVersion] = None,
    modelPackagingJobDescription: Option[ModelPackagingJobDescription] = None,
    modelPackagingMethod: Option[ModelPackagingMethod] = None,
    status: Option[zio.aws.lookoutvision.model.ModelPackagingJobStatus] = None,
    statusMessage: Option[ModelPackagingStatusMessage] = None,
    creationTimestamp: Option[DateTime] = None,
    lastUpdatedTimestamp: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobMetadata = {
    import ModelPackagingJobMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobMetadata
      .builder()
      .optionallyWith(
        jobName.map(value =>
          ModelPackagingJobName.unwrap(value): java.lang.String
        )
      )(_.jobName)
      .optionallyWith(
        projectName.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(
        modelVersion.map(value => ModelVersion.unwrap(value): java.lang.String)
      )(_.modelVersion)
      .optionallyWith(
        modelPackagingJobDescription.map(value =>
          ModelPackagingJobDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackagingJobDescription)
      .optionallyWith(
        modelPackagingMethod.map(value =>
          ModelPackagingMethod.unwrap(value): java.lang.String
        )
      )(_.modelPackagingMethod)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          ModelPackagingStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.ModelPackagingJobMetadata.ReadOnly =
    zio.aws.lookoutvision.model.ModelPackagingJobMetadata.wrap(buildAwsValue())
}
object ModelPackagingJobMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ModelPackagingJobMetadata =
      zio.aws.lookoutvision.model.ModelPackagingJobMetadata(
        jobName.map(value => value),
        projectName.map(value => value),
        modelVersion.map(value => value),
        modelPackagingJobDescription.map(value => value),
        modelPackagingMethod.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        creationTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def jobName: Option[ModelPackagingJobName]
    def projectName: Option[ProjectName]
    def modelVersion: Option[ModelVersion]
    def modelPackagingJobDescription: Option[ModelPackagingJobDescription]
    def modelPackagingMethod: Option[ModelPackagingMethod]
    def status: Option[zio.aws.lookoutvision.model.ModelPackagingJobStatus]
    def statusMessage: Option[ModelPackagingStatusMessage]
    def creationTimestamp: Option[DateTime]
    def lastUpdatedTimestamp: Option[DateTime]
    def getJobName: ZIO[Any, AwsError, ModelPackagingJobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getProjectName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getModelPackagingJobDescription
        : ZIO[Any, AwsError, ModelPackagingJobDescription] =
      AwsError.unwrapOptionField(
        "modelPackagingJobDescription",
        modelPackagingJobDescription
      )
    def getModelPackagingMethod: ZIO[Any, AwsError, ModelPackagingMethod] =
      AwsError.unwrapOptionField("modelPackagingMethod", modelPackagingMethod)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelPackagingJobStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, ModelPackagingStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobMetadata
  ) extends zio.aws.lookoutvision.model.ModelPackagingJobMetadata.ReadOnly {
    override val jobName: Option[ModelPackagingJobName] = scala
      .Option(impl.jobName())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ModelPackagingJobName(value)
      )
    override val projectName: Option[ProjectName] = scala
      .Option(impl.projectName())
      .map(value => zio.aws.lookoutvision.model.primitives.ProjectName(value))
    override val modelVersion: Option[ModelVersion] = scala
      .Option(impl.modelVersion())
      .map(value => zio.aws.lookoutvision.model.primitives.ModelVersion(value))
    override val modelPackagingJobDescription
        : Option[ModelPackagingJobDescription] = scala
      .Option(impl.modelPackagingJobDescription())
      .map(value =>
        zio.aws.lookoutvision.model.primitives
          .ModelPackagingJobDescription(value)
      )
    override val modelPackagingMethod: Option[ModelPackagingMethod] = scala
      .Option(impl.modelPackagingMethod())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ModelPackagingMethod(value)
      )
    override val status
        : Option[zio.aws.lookoutvision.model.ModelPackagingJobStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.lookoutvision.model.ModelPackagingJobStatus.wrap(value)
      )
    override val statusMessage: Option[ModelPackagingStatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.lookoutvision.model.primitives
          .ModelPackagingStatusMessage(value)
      )
    override val creationTimestamp: Option[DateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val lastUpdatedTimestamp: Option[DateTime] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelPackagingJobMetadata
  ): zio.aws.lookoutvision.model.ModelPackagingJobMetadata.ReadOnly =
    new Wrapper(impl)
}
