package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDatasetResponse(
    datasetDescription: Option[zio.aws.lookoutvision.model.DatasetDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetResponse = {
    import DescribeDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetResponse
      .builder()
      .optionallyWith(datasetDescription.map(value => value.buildAwsValue()))(
        _.datasetDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DescribeDatasetResponse.ReadOnly =
    zio.aws.lookoutvision.model.DescribeDatasetResponse.wrap(buildAwsValue())
}
object DescribeDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DescribeDatasetResponse =
      zio.aws.lookoutvision.model.DescribeDatasetResponse(
        datasetDescription.map(value => value.asEditable)
      )
    def datasetDescription
        : Option[zio.aws.lookoutvision.model.DatasetDescription.ReadOnly]
    def getDatasetDescription: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.DatasetDescription.ReadOnly
    ] = AwsError.unwrapOptionField("datasetDescription", datasetDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetResponse
  ) extends zio.aws.lookoutvision.model.DescribeDatasetResponse.ReadOnly {
    override val datasetDescription
        : Option[zio.aws.lookoutvision.model.DatasetDescription.ReadOnly] =
      scala
        .Option(impl.datasetDescription())
        .map(value =>
          zio.aws.lookoutvision.model.DatasetDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DescribeDatasetResponse
  ): zio.aws.lookoutvision.model.DescribeDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
