package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  ClientToken,
  ModelVersionNoLatest,
  ProjectName
}
import scala.jdk.CollectionConverters._
final case class DeleteModelRequest(
    projectName: ProjectName,
    modelVersion: ModelVersionNoLatest,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DeleteModelRequest = {
    import DeleteModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DeleteModelRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .modelVersion(ModelVersionNoLatest.unwrap(modelVersion): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DeleteModelRequest.ReadOnly =
    zio.aws.lookoutvision.model.DeleteModelRequest.wrap(buildAwsValue())
}
object DeleteModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DeleteModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DeleteModelRequest =
      zio.aws.lookoutvision.model.DeleteModelRequest(
        projectName,
        modelVersion,
        clientToken.map(value => value)
      )
    def projectName: ProjectName
    def modelVersion: ModelVersionNoLatest
    def clientToken: Option[ClientToken]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getModelVersion: ZIO[Any, Nothing, ModelVersionNoLatest] =
      ZIO.succeed(modelVersion)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DeleteModelRequest
  ) extends zio.aws.lookoutvision.model.DeleteModelRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val modelVersion: ModelVersionNoLatest =
      zio.aws.lookoutvision.model.primitives
        .ModelVersionNoLatest(impl.modelVersion())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.lookoutvision.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DeleteModelRequest
  ): zio.aws.lookoutvision.model.DeleteModelRequest.ReadOnly = new Wrapper(impl)
}
