package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  ComponentDescription,
  ComponentVersion,
  ComponentName,
  CompilerOptions
}
import scala.jdk.CollectionConverters._
final case class GreengrassConfiguration(
    compilerOptions: Option[CompilerOptions] = None,
    targetDevice: Option[zio.aws.lookoutvision.model.TargetDevice] = None,
    targetPlatform: Option[zio.aws.lookoutvision.model.TargetPlatform] = None,
    s3OutputLocation: zio.aws.lookoutvision.model.S3Location,
    componentName: ComponentName,
    componentVersion: Option[ComponentVersion] = None,
    componentDescription: Option[ComponentDescription] = None,
    tags: Option[Iterable[zio.aws.lookoutvision.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.GreengrassConfiguration = {
    import GreengrassConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.GreengrassConfiguration
      .builder()
      .optionallyWith(
        compilerOptions.map(value =>
          CompilerOptions.unwrap(value): java.lang.String
        )
      )(_.compilerOptions)
      .optionallyWith(targetDevice.map(value => value.unwrap))(_.targetDevice)
      .optionallyWith(targetPlatform.map(value => value.buildAwsValue()))(
        _.targetPlatform
      )
      .s3OutputLocation(s3OutputLocation.buildAwsValue())
      .componentName(ComponentName.unwrap(componentName): java.lang.String)
      .optionallyWith(
        componentVersion.map(value =>
          ComponentVersion.unwrap(value): java.lang.String
        )
      )(_.componentVersion)
      .optionallyWith(
        componentDescription.map(value =>
          ComponentDescription.unwrap(value): java.lang.String
        )
      )(_.componentDescription)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.GreengrassConfiguration.ReadOnly =
    zio.aws.lookoutvision.model.GreengrassConfiguration.wrap(buildAwsValue())
}
object GreengrassConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.GreengrassConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.GreengrassConfiguration =
      zio.aws.lookoutvision.model.GreengrassConfiguration(
        compilerOptions.map(value => value),
        targetDevice.map(value => value),
        targetPlatform.map(value => value.asEditable),
        s3OutputLocation.asEditable,
        componentName,
        componentVersion.map(value => value),
        componentDescription.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def compilerOptions: Option[CompilerOptions]
    def targetDevice: Option[zio.aws.lookoutvision.model.TargetDevice]
    def targetPlatform
        : Option[zio.aws.lookoutvision.model.TargetPlatform.ReadOnly]
    def s3OutputLocation: zio.aws.lookoutvision.model.S3Location.ReadOnly
    def componentName: ComponentName
    def componentVersion: Option[ComponentVersion]
    def componentDescription: Option[ComponentDescription]
    def tags: Option[List[zio.aws.lookoutvision.model.Tag.ReadOnly]]
    def getCompilerOptions: ZIO[Any, AwsError, CompilerOptions] =
      AwsError.unwrapOptionField("compilerOptions", compilerOptions)
    def getTargetDevice
        : ZIO[Any, AwsError, zio.aws.lookoutvision.model.TargetDevice] =
      AwsError.unwrapOptionField("targetDevice", targetDevice)
    def getTargetPlatform: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.TargetPlatform.ReadOnly
    ] = AwsError.unwrapOptionField("targetPlatform", targetPlatform)
    def getS3OutputLocation
        : ZIO[Any, Nothing, zio.aws.lookoutvision.model.S3Location.ReadOnly] =
      ZIO.succeed(s3OutputLocation)
    def getComponentName: ZIO[Any, Nothing, ComponentName] =
      ZIO.succeed(componentName)
    def getComponentVersion: ZIO[Any, AwsError, ComponentVersion] =
      AwsError.unwrapOptionField("componentVersion", componentVersion)
    def getComponentDescription: ZIO[Any, AwsError, ComponentDescription] =
      AwsError.unwrapOptionField("componentDescription", componentDescription)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lookoutvision.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.GreengrassConfiguration
  ) extends zio.aws.lookoutvision.model.GreengrassConfiguration.ReadOnly {
    override val compilerOptions: Option[CompilerOptions] = scala
      .Option(impl.compilerOptions())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.CompilerOptions(value)
      )
    override val targetDevice
        : Option[zio.aws.lookoutvision.model.TargetDevice] = scala
      .Option(impl.targetDevice())
      .map(value => zio.aws.lookoutvision.model.TargetDevice.wrap(value))
    override val targetPlatform
        : Option[zio.aws.lookoutvision.model.TargetPlatform.ReadOnly] = scala
      .Option(impl.targetPlatform())
      .map(value => zio.aws.lookoutvision.model.TargetPlatform.wrap(value))
    override val s3OutputLocation
        : zio.aws.lookoutvision.model.S3Location.ReadOnly =
      zio.aws.lookoutvision.model.S3Location.wrap(impl.s3OutputLocation())
    override val componentName: ComponentName =
      zio.aws.lookoutvision.model.primitives.ComponentName(impl.componentName())
    override val componentVersion: Option[ComponentVersion] = scala
      .Option(impl.componentVersion())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ComponentVersion(value)
      )
    override val componentDescription: Option[ComponentDescription] = scala
      .Option(impl.componentDescription())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ComponentDescription(value)
      )
    override val tags: Option[List[zio.aws.lookoutvision.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutvision.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.GreengrassConfiguration
  ): zio.aws.lookoutvision.model.GreengrassConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
