package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartModelResponse(
    status: Option[zio.aws.lookoutvision.model.ModelHostingStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.StartModelResponse = {
    import StartModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.StartModelResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.StartModelResponse.ReadOnly =
    zio.aws.lookoutvision.model.StartModelResponse.wrap(buildAwsValue())
}
object StartModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.StartModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.StartModelResponse =
      zio.aws.lookoutvision.model.StartModelResponse(status.map(value => value))
    def status: Option[zio.aws.lookoutvision.model.ModelHostingStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutvision.model.ModelHostingStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.StartModelResponse
  ) extends zio.aws.lookoutvision.model.StartModelResponse.ReadOnly {
    override val status
        : Option[zio.aws.lookoutvision.model.ModelHostingStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.lookoutvision.model.ModelHostingStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.StartModelResponse
  ): zio.aws.lookoutvision.model.StartModelResponse.ReadOnly = new Wrapper(impl)
}
