package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListModelsResponse(
    models: Option[Iterable[zio.aws.lookoutvision.model.ModelMetadata]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse = {
    import ListModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse
      .builder()
      .optionallyWith(
        models.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.models)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ListModelsResponse.ReadOnly =
    zio.aws.lookoutvision.model.ListModelsResponse.wrap(buildAwsValue())
}
object ListModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ListModelsResponse =
      zio.aws.lookoutvision.model.ListModelsResponse(
        models.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def models: Option[List[zio.aws.lookoutvision.model.ModelMetadata.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getModels: ZIO[Any, AwsError, List[
      zio.aws.lookoutvision.model.ModelMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("models", models)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse
  ) extends zio.aws.lookoutvision.model.ListModelsResponse.ReadOnly {
    override val models
        : Option[List[zio.aws.lookoutvision.model.ModelMetadata.ReadOnly]] =
      scala
        .Option(impl.models())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutvision.model.ModelMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse
  ): zio.aws.lookoutvision.model.ListModelsResponse.ReadOnly = new Wrapper(impl)
}
