package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListModelPackagingJobsResponse(
    modelPackagingJobs: Option[
      Iterable[zio.aws.lookoutvision.model.ModelPackagingJobMetadata]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse = {
    import ListModelPackagingJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse
      .builder()
      .optionallyWith(
        modelPackagingJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelPackagingJobs)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.ListModelPackagingJobsResponse.ReadOnly =
    zio.aws.lookoutvision.model.ListModelPackagingJobsResponse
      .wrap(buildAwsValue())
}
object ListModelPackagingJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ListModelPackagingJobsResponse =
      zio.aws.lookoutvision.model.ListModelPackagingJobsResponse(
        modelPackagingJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def modelPackagingJobs: Option[
      List[zio.aws.lookoutvision.model.ModelPackagingJobMetadata.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getModelPackagingJobs: ZIO[Any, AwsError, List[
      zio.aws.lookoutvision.model.ModelPackagingJobMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("modelPackagingJobs", modelPackagingJobs)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse
  ) extends zio.aws.lookoutvision.model.ListModelPackagingJobsResponse.ReadOnly {
    override val modelPackagingJobs: Option[
      List[zio.aws.lookoutvision.model.ModelPackagingJobMetadata.ReadOnly]
    ] = scala
      .Option(impl.modelPackagingJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutvision.model.ModelPackagingJobMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ListModelPackagingJobsResponse
  ): zio.aws.lookoutvision.model.ListModelPackagingJobsResponse.ReadOnly =
    new Wrapper(impl)
}
