package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  S3ObjectVersion,
  S3ObjectKey,
  S3BucketName
}
import scala.jdk.CollectionConverters._
final case class InputS3Object(
    bucket: S3BucketName,
    key: S3ObjectKey,
    versionId: Option[S3ObjectVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.InputS3Object = {
    import InputS3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.InputS3Object
      .builder()
      .bucket(S3BucketName.unwrap(bucket): java.lang.String)
      .key(S3ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(
        versionId.map(value => S3ObjectVersion.unwrap(value): java.lang.String)
      )(_.versionId)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.InputS3Object.ReadOnly =
    zio.aws.lookoutvision.model.InputS3Object.wrap(buildAwsValue())
}
object InputS3Object {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.InputS3Object
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.InputS3Object =
      zio.aws.lookoutvision.model
        .InputS3Object(bucket, key, versionId.map(value => value))
    def bucket: S3BucketName
    def key: S3ObjectKey
    def versionId: Option[S3ObjectVersion]
    def getBucket: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, S3ObjectKey] = ZIO.succeed(key)
    def getVersionId: ZIO[Any, AwsError, S3ObjectVersion] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.InputS3Object
  ) extends zio.aws.lookoutvision.model.InputS3Object.ReadOnly {
    override val bucket: S3BucketName =
      zio.aws.lookoutvision.model.primitives.S3BucketName(impl.bucket())
    override val key: S3ObjectKey =
      zio.aws.lookoutvision.model.primitives.S3ObjectKey(impl.key())
    override val versionId: Option[S3ObjectVersion] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.S3ObjectVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.InputS3Object
  ): zio.aws.lookoutvision.model.InputS3Object.ReadOnly = new Wrapper(impl)
}
