package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  DatasetStatusMessage,
  DateTime,
  DatasetType
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DatasetMetadata(
    datasetType: Option[DatasetType] = None,
    creationTimestamp: Option[DateTime] = None,
    status: Option[zio.aws.lookoutvision.model.DatasetStatus] = None,
    statusMessage: Option[DatasetStatusMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DatasetMetadata = {
    import DatasetMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DatasetMetadata
      .builder()
      .optionallyWith(
        datasetType.map(value => DatasetType.unwrap(value): java.lang.String)
      )(_.datasetType)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          DatasetStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DatasetMetadata.ReadOnly =
    zio.aws.lookoutvision.model.DatasetMetadata.wrap(buildAwsValue())
}
object DatasetMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DatasetMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DatasetMetadata =
      zio.aws.lookoutvision.model.DatasetMetadata(
        datasetType.map(value => value),
        creationTimestamp.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def datasetType: Option[DatasetType]
    def creationTimestamp: Option[DateTime]
    def status: Option[zio.aws.lookoutvision.model.DatasetStatus]
    def statusMessage: Option[DatasetStatusMessage]
    def getDatasetType: ZIO[Any, AwsError, DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutvision.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, DatasetStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DatasetMetadata
  ) extends zio.aws.lookoutvision.model.DatasetMetadata.ReadOnly {
    override val datasetType: Option[DatasetType] = scala
      .Option(impl.datasetType())
      .map(value => zio.aws.lookoutvision.model.primitives.DatasetType(value))
    override val creationTimestamp: Option[DateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val status: Option[zio.aws.lookoutvision.model.DatasetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.lookoutvision.model.DatasetStatus.wrap(value))
    override val statusMessage: Option[DatasetStatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.DatasetStatusMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DatasetMetadata
  ): zio.aws.lookoutvision.model.DatasetMetadata.ReadOnly = new Wrapper(impl)
}
