package zio.aws.lookoutvision
import zio.aws.lookoutvision.model.UntagResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.lookoutvision.LookoutVisionAsyncClient
import zio.aws.lookoutvision.model.{
  CreateDatasetRequest,
  CreateProjectRequest,
  StartModelPackagingJobRequest,
  DescribeDatasetRequest,
  DescribeModelRequest,
  ListTagsForResourceRequest,
  CreateModelRequest,
  DeleteProjectRequest,
  ListModelsRequest,
  ListDatasetEntriesRequest,
  StopModelRequest,
  DeleteDatasetRequest,
  ListProjectsRequest,
  UntagResourceRequest,
  DetectAnomaliesRequest,
  UpdateDatasetEntriesRequest,
  ListModelPackagingJobsRequest,
  DescribeModelPackagingJobRequest,
  DeleteModelRequest,
  StartModelRequest,
  DescribeProjectRequest,
  TagResourceRequest
}
import zio.aws.lookoutvision.model.primitives.DatasetEntry
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object LookoutVisionMock extends Mock[LookoutVision] {
  object ListDatasetEntries
      extends Stream[ListDatasetEntriesRequest, AwsError, DatasetEntry]
  object ListDatasetEntriesPaginated
      extends Effect[
        ListDatasetEntriesRequest,
        AwsError,
        zio.aws.lookoutvision.model.ListDatasetEntriesResponse.ReadOnly
      ]
  object CreateDataset
      extends Effect[
        CreateDatasetRequest,
        AwsError,
        zio.aws.lookoutvision.model.CreateDatasetResponse.ReadOnly
      ]
  object ListModels
      extends Stream[
        ListModelsRequest,
        AwsError,
        zio.aws.lookoutvision.model.ModelMetadata.ReadOnly
      ]
  object ListModelsPaginated
      extends Effect[
        ListModelsRequest,
        AwsError,
        zio.aws.lookoutvision.model.ListModelsResponse.ReadOnly
      ]
  object CreateModel
      extends Effect[
        CreateModelRequest,
        AwsError,
        zio.aws.lookoutvision.model.CreateModelResponse.ReadOnly
      ]
  object UpdateDatasetEntries
      extends Effect[
        UpdateDatasetEntriesRequest,
        AwsError,
        zio.aws.lookoutvision.model.UpdateDatasetEntriesResponse.ReadOnly
      ]
  object DescribeDataset
      extends Effect[
        DescribeDatasetRequest,
        AwsError,
        zio.aws.lookoutvision.model.DescribeDatasetResponse.ReadOnly
      ]
  object ListProjects
      extends Stream[
        ListProjectsRequest,
        AwsError,
        zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly
      ]
  object ListProjectsPaginated
      extends Effect[
        ListProjectsRequest,
        AwsError,
        zio.aws.lookoutvision.model.ListProjectsResponse.ReadOnly
      ]
  object DeleteModel
      extends Effect[
        DeleteModelRequest,
        AwsError,
        zio.aws.lookoutvision.model.DeleteModelResponse.ReadOnly
      ]
  object StopModel
      extends Effect[
        StopModelRequest,
        AwsError,
        zio.aws.lookoutvision.model.StopModelResponse.ReadOnly
      ]
  object DescribeModelPackagingJob
      extends Effect[
        DescribeModelPackagingJobRequest,
        AwsError,
        zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse.ReadOnly
      ]
  object StartModelPackagingJob
      extends Effect[
        StartModelPackagingJobRequest,
        AwsError,
        zio.aws.lookoutvision.model.StartModelPackagingJobResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, ReadOnly]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.lookoutvision.model.CreateProjectResponse.ReadOnly
      ]
  object StartModel
      extends Effect[
        StartModelRequest,
        AwsError,
        zio.aws.lookoutvision.model.StartModelResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.lookoutvision.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeProject
      extends Effect[
        DescribeProjectRequest,
        AwsError,
        zio.aws.lookoutvision.model.DescribeProjectResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.lookoutvision.model.TagResourceResponse.ReadOnly
      ]
  object DetectAnomalies
      extends Effect[
        Tuple2[DetectAnomaliesRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        zio.aws.lookoutvision.model.DetectAnomaliesResponse.ReadOnly
      ]
  object DeleteDataset
      extends Effect[
        DeleteDatasetRequest,
        AwsError,
        zio.aws.lookoutvision.model.DeleteDatasetResponse.ReadOnly
      ]
  object ListModelPackagingJobs
      extends Stream[
        ListModelPackagingJobsRequest,
        AwsError,
        zio.aws.lookoutvision.model.ModelPackagingJobMetadata.ReadOnly
      ]
  object ListModelPackagingJobsPaginated
      extends Effect[
        ListModelPackagingJobsRequest,
        AwsError,
        zio.aws.lookoutvision.model.ListModelPackagingJobsResponse.ReadOnly
      ]
  object DeleteProject
      extends Effect[
        DeleteProjectRequest,
        AwsError,
        zio.aws.lookoutvision.model.DeleteProjectResponse.ReadOnly
      ]
  object DescribeModel
      extends Effect[
        DescribeModelRequest,
        AwsError,
        zio.aws.lookoutvision.model.DescribeModelResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, LookoutVision] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new LookoutVision {
          val api: LookoutVisionAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : LookoutVision = this
          def listDatasetEntries(
              request: ListDatasetEntriesRequest
          ): ZStream[Any, AwsError, DatasetEntry] =
            rts.unsafeRun(proxy(ListDatasetEntries, request))
          def listDatasetEntriesPaginated(
              request: ListDatasetEntriesRequest
          ): IO[
            AwsError,
            zio.aws.lookoutvision.model.ListDatasetEntriesResponse.ReadOnly
          ] = proxy(ListDatasetEntriesPaginated, request)
          def createDataset(request: CreateDatasetRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.CreateDatasetResponse.ReadOnly
          ] = proxy(CreateDataset, request)
          def listModels(request: ListModelsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.lookoutvision.model.ModelMetadata.ReadOnly
          ] = rts.unsafeRun(proxy(ListModels, request))
          def listModelsPaginated(request: ListModelsRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.ListModelsResponse.ReadOnly
          ] = proxy(ListModelsPaginated, request)
          def createModel(request: CreateModelRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.CreateModelResponse.ReadOnly
          ] = proxy(CreateModel, request)
          def updateDatasetEntries(request: UpdateDatasetEntriesRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.UpdateDatasetEntriesResponse.ReadOnly
          ] = proxy(UpdateDatasetEntries, request)
          def describeDataset(request: DescribeDatasetRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.DescribeDatasetResponse.ReadOnly
          ] = proxy(DescribeDataset, request)
          def listProjects(request: ListProjectsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.lookoutvision.model.ProjectMetadata.ReadOnly
          ] = rts.unsafeRun(proxy(ListProjects, request))
          def listProjectsPaginated(request: ListProjectsRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.ListProjectsResponse.ReadOnly
          ] = proxy(ListProjectsPaginated, request)
          def deleteModel(request: DeleteModelRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.DeleteModelResponse.ReadOnly
          ] = proxy(DeleteModel, request)
          def stopModel(request: StopModelRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.StopModelResponse.ReadOnly
          ] = proxy(StopModel, request)
          def describeModelPackagingJob(
              request: DescribeModelPackagingJobRequest
          ): IO[
            AwsError,
            zio.aws.lookoutvision.model.DescribeModelPackagingJobResponse.ReadOnly
          ] = proxy(DescribeModelPackagingJob, request)
          def startModelPackagingJob(
              request: StartModelPackagingJobRequest
          ): IO[
            AwsError,
            zio.aws.lookoutvision.model.StartModelPackagingJobResponse.ReadOnly
          ] = proxy(StartModelPackagingJob, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, ReadOnly] = proxy(UntagResource, request)
          def createProject(request: CreateProjectRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.CreateProjectResponse.ReadOnly
          ] = proxy(CreateProject, request)
          def startModel(request: StartModelRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.StartModelResponse.ReadOnly
          ] = proxy(StartModel, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def describeProject(request: DescribeProjectRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.DescribeProjectResponse.ReadOnly
          ] = proxy(DescribeProject, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def detectAnomalies(
              request: DetectAnomaliesRequest,
              body: ZStream[Any, AwsError, Byte]
          ): IO[
            AwsError,
            zio.aws.lookoutvision.model.DetectAnomaliesResponse.ReadOnly
          ] = proxy(DetectAnomalies, request, body)
          def deleteDataset(request: DeleteDatasetRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.DeleteDatasetResponse.ReadOnly
          ] = proxy(DeleteDataset, request)
          def listModelPackagingJobs(
              request: ListModelPackagingJobsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.lookoutvision.model.ModelPackagingJobMetadata.ReadOnly
          ] = rts.unsafeRun(proxy(ListModelPackagingJobs, request))
          def listModelPackagingJobsPaginated(
              request: ListModelPackagingJobsRequest
          ): IO[
            AwsError,
            zio.aws.lookoutvision.model.ListModelPackagingJobsResponse.ReadOnly
          ] = proxy(ListModelPackagingJobsPaginated, request)
          def deleteProject(request: DeleteProjectRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.DeleteProjectResponse.ReadOnly
          ] = proxy(DeleteProject, request)
          def describeModel(request: DescribeModelRequest): IO[
            AwsError,
            zio.aws.lookoutvision.model.DescribeModelResponse.ReadOnly
          ] = proxy(DescribeModel, request)
        }
      }
    }
    .toLayer
}
