package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDatasetEntriesResponse(
    status: Option[zio.aws.lookoutvision.model.DatasetStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesResponse = {
    import UpdateDatasetEntriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.UpdateDatasetEntriesResponse.ReadOnly =
    zio.aws.lookoutvision.model.UpdateDatasetEntriesResponse
      .wrap(buildAwsValue())
}
object UpdateDatasetEntriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.UpdateDatasetEntriesResponse =
      zio.aws.lookoutvision.model
        .UpdateDatasetEntriesResponse(status.map(value => value))
    def status: Option[zio.aws.lookoutvision.model.DatasetStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutvision.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesResponse
  ) extends zio.aws.lookoutvision.model.UpdateDatasetEntriesResponse.ReadOnly {
    override val status: Option[zio.aws.lookoutvision.model.DatasetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.lookoutvision.model.DatasetStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.UpdateDatasetEntriesResponse
  ): zio.aws.lookoutvision.model.UpdateDatasetEntriesResponse.ReadOnly =
    new Wrapper(impl)
}
