package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TargetPlatform(
    os: zio.aws.lookoutvision.model.TargetPlatformOs,
    arch: zio.aws.lookoutvision.model.TargetPlatformArch,
    accelerator: zio.aws.lookoutvision.model.TargetPlatformAccelerator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.TargetPlatform = {
    import TargetPlatform.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.TargetPlatform
      .builder()
      .os(os.unwrap)
      .arch(arch.unwrap)
      .accelerator(accelerator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.TargetPlatform.ReadOnly =
    zio.aws.lookoutvision.model.TargetPlatform.wrap(buildAwsValue())
}
object TargetPlatform {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.TargetPlatform
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.TargetPlatform =
      zio.aws.lookoutvision.model.TargetPlatform(os, arch, accelerator)
    def os: zio.aws.lookoutvision.model.TargetPlatformOs
    def arch: zio.aws.lookoutvision.model.TargetPlatformArch
    def accelerator: zio.aws.lookoutvision.model.TargetPlatformAccelerator
    def getOs: ZIO[Any, Nothing, zio.aws.lookoutvision.model.TargetPlatformOs] =
      ZIO.succeed(os)
    def getArch
        : ZIO[Any, Nothing, zio.aws.lookoutvision.model.TargetPlatformArch] =
      ZIO.succeed(arch)
    def getAccelerator: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutvision.model.TargetPlatformAccelerator
    ] = ZIO.succeed(accelerator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.TargetPlatform
  ) extends zio.aws.lookoutvision.model.TargetPlatform.ReadOnly {
    override val os: zio.aws.lookoutvision.model.TargetPlatformOs =
      zio.aws.lookoutvision.model.TargetPlatformOs.wrap(impl.os())
    override val arch: zio.aws.lookoutvision.model.TargetPlatformArch =
      zio.aws.lookoutvision.model.TargetPlatformArch.wrap(impl.arch())
    override val accelerator
        : zio.aws.lookoutvision.model.TargetPlatformAccelerator =
      zio.aws.lookoutvision.model.TargetPlatformAccelerator
        .wrap(impl.accelerator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.TargetPlatform
  ): zio.aws.lookoutvision.model.TargetPlatform.ReadOnly = new Wrapper(impl)
}
