package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StopModelResponse(
    status: Option[zio.aws.lookoutvision.model.ModelHostingStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.StopModelResponse = {
    import StopModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.StopModelResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.StopModelResponse.ReadOnly =
    zio.aws.lookoutvision.model.StopModelResponse.wrap(buildAwsValue())
}
object StopModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.StopModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.StopModelResponse =
      zio.aws.lookoutvision.model.StopModelResponse(status.map(value => value))
    def status: Option[zio.aws.lookoutvision.model.ModelHostingStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutvision.model.ModelHostingStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.StopModelResponse
  ) extends zio.aws.lookoutvision.model.StopModelResponse.ReadOnly {
    override val status
        : Option[zio.aws.lookoutvision.model.ModelHostingStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.lookoutvision.model.ModelHostingStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.StopModelResponse
  ): zio.aws.lookoutvision.model.StopModelResponse.ReadOnly = new Wrapper(impl)
}
