package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  ModelArn,
  ModelVersion,
  DateTime,
  KmsKeyId,
  ModelStatusMessage,
  ModelDescriptionMessage
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ModelDescription(
    modelVersion: Option[ModelVersion] = None,
    modelArn: Option[ModelArn] = None,
    creationTimestamp: Option[DateTime] = None,
    description: Option[ModelDescriptionMessage] = None,
    status: Option[zio.aws.lookoutvision.model.ModelStatus] = None,
    statusMessage: Option[ModelStatusMessage] = None,
    performance: Option[zio.aws.lookoutvision.model.ModelPerformance] = None,
    outputConfig: Option[zio.aws.lookoutvision.model.OutputConfig] = None,
    evaluationManifest: Option[zio.aws.lookoutvision.model.OutputS3Object] =
      None,
    evaluationResult: Option[zio.aws.lookoutvision.model.OutputS3Object] = None,
    evaluationEndTimestamp: Option[DateTime] = None,
    kmsKeyId: Option[KmsKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.ModelDescription = {
    import ModelDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.ModelDescription
      .builder()
      .optionallyWith(
        modelVersion.map(value => ModelVersion.unwrap(value): java.lang.String)
      )(_.modelVersion)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        description.map(value =>
          ModelDescriptionMessage.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          ModelStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(performance.map(value => value.buildAwsValue()))(
        _.performance
      )
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(evaluationManifest.map(value => value.buildAwsValue()))(
        _.evaluationManifest
      )
      .optionallyWith(evaluationResult.map(value => value.buildAwsValue()))(
        _.evaluationResult
      )
      .optionallyWith(
        evaluationEndTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.evaluationEndTimestamp)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.ModelDescription.ReadOnly =
    zio.aws.lookoutvision.model.ModelDescription.wrap(buildAwsValue())
}
object ModelDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.ModelDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.ModelDescription =
      zio.aws.lookoutvision.model.ModelDescription(
        modelVersion.map(value => value),
        modelArn.map(value => value),
        creationTimestamp.map(value => value),
        description.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        performance.map(value => value.asEditable),
        outputConfig.map(value => value.asEditable),
        evaluationManifest.map(value => value.asEditable),
        evaluationResult.map(value => value.asEditable),
        evaluationEndTimestamp.map(value => value),
        kmsKeyId.map(value => value)
      )
    def modelVersion: Option[ModelVersion]
    def modelArn: Option[ModelArn]
    def creationTimestamp: Option[DateTime]
    def description: Option[ModelDescriptionMessage]
    def status: Option[zio.aws.lookoutvision.model.ModelStatus]
    def statusMessage: Option[ModelStatusMessage]
    def performance
        : Option[zio.aws.lookoutvision.model.ModelPerformance.ReadOnly]
    def outputConfig: Option[zio.aws.lookoutvision.model.OutputConfig.ReadOnly]
    def evaluationManifest
        : Option[zio.aws.lookoutvision.model.OutputS3Object.ReadOnly]
    def evaluationResult
        : Option[zio.aws.lookoutvision.model.OutputS3Object.ReadOnly]
    def evaluationEndTimestamp: Option[DateTime]
    def kmsKeyId: Option[KmsKeyId]
    def getModelVersion: ZIO[Any, AwsError, ModelVersion] =
      AwsError.unwrapOptionField("modelVersion", modelVersion)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getDescription: ZIO[Any, AwsError, ModelDescriptionMessage] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.lookoutvision.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, ModelStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getPerformance: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.ModelPerformance.ReadOnly
    ] = AwsError.unwrapOptionField("performance", performance)
    def getOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.OutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getEvaluationManifest: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.OutputS3Object.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationManifest", evaluationManifest)
    def getEvaluationResult: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.OutputS3Object.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationResult", evaluationResult)
    def getEvaluationEndTimestamp: ZIO[Any, AwsError, DateTime] = AwsError
      .unwrapOptionField("evaluationEndTimestamp", evaluationEndTimestamp)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelDescription
  ) extends zio.aws.lookoutvision.model.ModelDescription.ReadOnly {
    override val modelVersion: Option[ModelVersion] = scala
      .Option(impl.modelVersion())
      .map(value => zio.aws.lookoutvision.model.primitives.ModelVersion(value))
    override val modelArn: Option[ModelArn] = scala
      .Option(impl.modelArn())
      .map(value => zio.aws.lookoutvision.model.primitives.ModelArn(value))
    override val creationTimestamp: Option[DateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val description: Option[ModelDescriptionMessage] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ModelDescriptionMessage(value)
      )
    override val status: Option[zio.aws.lookoutvision.model.ModelStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.lookoutvision.model.ModelStatus.wrap(value))
    override val statusMessage: Option[ModelStatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ModelStatusMessage(value)
      )
    override val performance
        : Option[zio.aws.lookoutvision.model.ModelPerformance.ReadOnly] = scala
      .Option(impl.performance())
      .map(value => zio.aws.lookoutvision.model.ModelPerformance.wrap(value))
    override val outputConfig
        : Option[zio.aws.lookoutvision.model.OutputConfig.ReadOnly] = scala
      .Option(impl.outputConfig())
      .map(value => zio.aws.lookoutvision.model.OutputConfig.wrap(value))
    override val evaluationManifest
        : Option[zio.aws.lookoutvision.model.OutputS3Object.ReadOnly] = scala
      .Option(impl.evaluationManifest())
      .map(value => zio.aws.lookoutvision.model.OutputS3Object.wrap(value))
    override val evaluationResult
        : Option[zio.aws.lookoutvision.model.OutputS3Object.ReadOnly] = scala
      .Option(impl.evaluationResult())
      .map(value => zio.aws.lookoutvision.model.OutputS3Object.wrap(value))
    override val evaluationEndTimestamp: Option[DateTime] = scala
      .Option(impl.evaluationEndTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.lookoutvision.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.ModelDescription
  ): zio.aws.lookoutvision.model.ModelDescription.ReadOnly = new Wrapper(impl)
}
