package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  DatasetStatusMessage,
  DateTime,
  DatasetType,
  ProjectName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DatasetDescription(
    projectName: Option[ProjectName] = None,
    datasetType: Option[DatasetType] = None,
    creationTimestamp: Option[DateTime] = None,
    lastUpdatedTimestamp: Option[DateTime] = None,
    status: Option[zio.aws.lookoutvision.model.DatasetStatus] = None,
    statusMessage: Option[DatasetStatusMessage] = None,
    imageStats: Option[zio.aws.lookoutvision.model.DatasetImageStats] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DatasetDescription = {
    import DatasetDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DatasetDescription
      .builder()
      .optionallyWith(
        projectName.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(
        datasetType.map(value => DatasetType.unwrap(value): java.lang.String)
      )(_.datasetType)
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          DatasetStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(imageStats.map(value => value.buildAwsValue()))(
        _.imageStats
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DatasetDescription.ReadOnly =
    zio.aws.lookoutvision.model.DatasetDescription.wrap(buildAwsValue())
}
object DatasetDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DatasetDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DatasetDescription =
      zio.aws.lookoutvision.model.DatasetDescription(
        projectName.map(value => value),
        datasetType.map(value => value),
        creationTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        imageStats.map(value => value.asEditable)
      )
    def projectName: Option[ProjectName]
    def datasetType: Option[DatasetType]
    def creationTimestamp: Option[DateTime]
    def lastUpdatedTimestamp: Option[DateTime]
    def status: Option[zio.aws.lookoutvision.model.DatasetStatus]
    def statusMessage: Option[DatasetStatusMessage]
    def imageStats
        : Option[zio.aws.lookoutvision.model.DatasetImageStats.ReadOnly]
    def getProjectName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getDatasetType: ZIO[Any, AwsError, DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutvision.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, DatasetStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getImageStats: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutvision.model.DatasetImageStats.ReadOnly
    ] = AwsError.unwrapOptionField("imageStats", imageStats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DatasetDescription
  ) extends zio.aws.lookoutvision.model.DatasetDescription.ReadOnly {
    override val projectName: Option[ProjectName] = scala
      .Option(impl.projectName())
      .map(value => zio.aws.lookoutvision.model.primitives.ProjectName(value))
    override val datasetType: Option[DatasetType] = scala
      .Option(impl.datasetType())
      .map(value => zio.aws.lookoutvision.model.primitives.DatasetType(value))
    override val creationTimestamp: Option[DateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val lastUpdatedTimestamp: Option[DateTime] = scala
      .Option(impl.lastUpdatedTimestamp())
      .map(value => zio.aws.lookoutvision.model.primitives.DateTime(value))
    override val status: Option[zio.aws.lookoutvision.model.DatasetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.lookoutvision.model.DatasetStatus.wrap(value))
    override val statusMessage: Option[DatasetStatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.DatasetStatusMessage(value)
      )
    override val imageStats
        : Option[zio.aws.lookoutvision.model.DatasetImageStats.ReadOnly] = scala
      .Option(impl.imageStats())
      .map(value => zio.aws.lookoutvision.model.DatasetImageStats.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DatasetDescription
  ): zio.aws.lookoutvision.model.DatasetDescription.ReadOnly = new Wrapper(impl)
}
