package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.ModelPackagingJobName
import scala.jdk.CollectionConverters._
final case class StartModelPackagingJobResponse(
    jobName: Option[ModelPackagingJobName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobResponse = {
    import StartModelPackagingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobResponse
      .builder()
      .optionallyWith(
        jobName.map(value =>
          ModelPackagingJobName.unwrap(value): java.lang.String
        )
      )(_.jobName)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutvision.model.StartModelPackagingJobResponse.ReadOnly =
    zio.aws.lookoutvision.model.StartModelPackagingJobResponse
      .wrap(buildAwsValue())
}
object StartModelPackagingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.StartModelPackagingJobResponse =
      zio.aws.lookoutvision.model
        .StartModelPackagingJobResponse(jobName.map(value => value))
    def jobName: Option[ModelPackagingJobName]
    def getJobName: ZIO[Any, AwsError, ModelPackagingJobName] =
      AwsError.unwrapOptionField("jobName", jobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobResponse
  ) extends zio.aws.lookoutvision.model.StartModelPackagingJobResponse.ReadOnly {
    override val jobName: Option[ModelPackagingJobName] = scala
      .Option(impl.jobName())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ModelPackagingJobName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.StartModelPackagingJobResponse
  ): zio.aws.lookoutvision.model.StartModelPackagingJobResponse.ReadOnly =
    new Wrapper(impl)
}
