package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  ComponentVersion,
  ComponentName,
  ComponentVersionArn
}
import scala.jdk.CollectionConverters._
final case class GreengrassOutputDetails(
    componentVersionArn: Option[ComponentVersionArn] = None,
    componentName: Option[ComponentName] = None,
    componentVersion: Option[ComponentVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.GreengrassOutputDetails = {
    import GreengrassOutputDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.GreengrassOutputDetails
      .builder()
      .optionallyWith(
        componentVersionArn.map(value =>
          ComponentVersionArn.unwrap(value): java.lang.String
        )
      )(_.componentVersionArn)
      .optionallyWith(
        componentName.map(value =>
          ComponentName.unwrap(value): java.lang.String
        )
      )(_.componentName)
      .optionallyWith(
        componentVersion.map(value =>
          ComponentVersion.unwrap(value): java.lang.String
        )
      )(_.componentVersion)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.GreengrassOutputDetails.ReadOnly =
    zio.aws.lookoutvision.model.GreengrassOutputDetails.wrap(buildAwsValue())
}
object GreengrassOutputDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.GreengrassOutputDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.GreengrassOutputDetails =
      zio.aws.lookoutvision.model.GreengrassOutputDetails(
        componentVersionArn.map(value => value),
        componentName.map(value => value),
        componentVersion.map(value => value)
      )
    def componentVersionArn: Option[ComponentVersionArn]
    def componentName: Option[ComponentName]
    def componentVersion: Option[ComponentVersion]
    def getComponentVersionArn: ZIO[Any, AwsError, ComponentVersionArn] =
      AwsError.unwrapOptionField("componentVersionArn", componentVersionArn)
    def getComponentName: ZIO[Any, AwsError, ComponentName] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getComponentVersion: ZIO[Any, AwsError, ComponentVersion] =
      AwsError.unwrapOptionField("componentVersion", componentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.GreengrassOutputDetails
  ) extends zio.aws.lookoutvision.model.GreengrassOutputDetails.ReadOnly {
    override val componentVersionArn: Option[ComponentVersionArn] = scala
      .Option(impl.componentVersionArn())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ComponentVersionArn(value)
      )
    override val componentName: Option[ComponentName] = scala
      .Option(impl.componentName())
      .map(value => zio.aws.lookoutvision.model.primitives.ComponentName(value))
    override val componentVersion: Option[ComponentVersion] = scala
      .Option(impl.componentVersion())
      .map(value =>
        zio.aws.lookoutvision.model.primitives.ComponentVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.GreengrassOutputDetails
  ): zio.aws.lookoutvision.model.GreengrassOutputDetails.ReadOnly = new Wrapper(
    impl
  )
}
