package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{ClientToken, ProjectName}
import scala.jdk.CollectionConverters._
final case class DeleteProjectRequest(
    projectName: ProjectName,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DeleteProjectRequest = {
    import DeleteProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DeleteProjectRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DeleteProjectRequest.ReadOnly =
    zio.aws.lookoutvision.model.DeleteProjectRequest.wrap(buildAwsValue())
}
object DeleteProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DeleteProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DeleteProjectRequest =
      zio.aws.lookoutvision.model
        .DeleteProjectRequest(projectName, clientToken.map(value => value))
    def projectName: ProjectName
    def clientToken: Option[ClientToken]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DeleteProjectRequest
  ) extends zio.aws.lookoutvision.model.DeleteProjectRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.lookoutvision.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DeleteProjectRequest
  ): zio.aws.lookoutvision.model.DeleteProjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
