package zio.aws.lookoutvision.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutvision.model.primitives.{
  ClientToken,
  DatasetType,
  ProjectName
}
import scala.jdk.CollectionConverters._
final case class DeleteDatasetRequest(
    projectName: ProjectName,
    datasetType: DatasetType,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetRequest = {
    import DeleteDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .datasetType(DatasetType.unwrap(datasetType): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.lookoutvision.model.DeleteDatasetRequest.ReadOnly =
    zio.aws.lookoutvision.model.DeleteDatasetRequest.wrap(buildAwsValue())
}
object DeleteDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutvision.model.DeleteDatasetRequest =
      zio.aws.lookoutvision.model.DeleteDatasetRequest(
        projectName,
        datasetType,
        clientToken.map(value => value)
      )
    def projectName: ProjectName
    def datasetType: DatasetType
    def clientToken: Option[ClientToken]
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
    def getDatasetType: ZIO[Any, Nothing, DatasetType] =
      ZIO.succeed(datasetType)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetRequest
  ) extends zio.aws.lookoutvision.model.DeleteDatasetRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.lookoutvision.model.primitives.ProjectName(impl.projectName())
    override val datasetType: DatasetType =
      zio.aws.lookoutvision.model.primitives.DatasetType(impl.datasetType())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.lookoutvision.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutvision.model.DeleteDatasetRequest
  ): zio.aws.lookoutvision.model.DeleteDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
